/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.emi;

import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.core.AEConfig;
import appeng.integration.modules.emi.EmiStackHelper;
import appeng.integration.modules.jeirei.EncodingHelper;
import appeng.integration.modules.jeirei.TransferHelper;
import appeng.menu.AEBaseMenu;
import appeng.menu.SlotSemantics;
import appeng.menu.me.common.GridInventoryEntry;
import appeng.menu.me.common.IClientRepo;
import appeng.menu.me.common.MEStorageMenu;
import appeng.menu.me.items.CraftingTermMenu;
import dev.emi.emi.api.recipe.EmiPlayerInventory;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5684;
import org.jetbrains.annotations.Nullable;

abstract class AbstractRecipeHandler<T extends AEBaseMenu>
implements StandardRecipeHandler<T> {
    protected static final int CRAFTING_GRID_WIDTH = 3;
    protected static final int CRAFTING_GRID_HEIGHT = 3;
    private final Class<T> containerClass;

    AbstractRecipeHandler(Class<T> containerClass) {
        this.containerClass = containerClass;
    }

    public List<class_1735> getInputSources(T menu) {
        ArrayList<class_1735> slots = new ArrayList<class_1735>();
        slots.addAll(((AEBaseMenu)((Object)menu)).getSlots(SlotSemantics.PLAYER_INVENTORY));
        slots.addAll(((AEBaseMenu)((Object)menu)).getSlots(SlotSemantics.PLAYER_HOTBAR));
        slots.addAll(((AEBaseMenu)((Object)menu)).getSlots(SlotSemantics.CRAFTING_GRID));
        return slots;
    }

    public List<class_1735> getCraftingSlots(T menu) {
        return ((AEBaseMenu)((Object)menu)).getSlots(SlotSemantics.CRAFTING_GRID);
    }

    @Nullable
    public class_1735 getOutputSlot(T menu) {
        Iterator<class_1735> iterator = ((AEBaseMenu)((Object)menu)).getSlots(SlotSemantics.CRAFTING_RESULT).iterator();
        if (iterator.hasNext()) {
            class_1735 slot = iterator.next();
            return slot;
        }
        return null;
    }

    public EmiPlayerInventory getInventory(class_465<T> screen) {
        MEStorageMenu menu;
        IClientRepo iClientRepo;
        if (!AEConfig.instance().isExposeNetworkInventoryToEmi()) {
            return super.getInventory(screen);
        }
        ArrayList<EmiStack> list = new ArrayList<EmiStack>();
        for (class_1735 class_17352 : this.getInputSources((T)((Object)((AEBaseMenu)screen.method_17577())))) {
            list.add(EmiStack.of((class_1799)class_17352.method_7677()));
        }
        class_1703 class_17032 = screen.method_17577();
        if (class_17032 instanceof MEStorageMenu && (iClientRepo = (menu = (MEStorageMenu)class_17032).getClientRepo()) != null) {
            for (GridInventoryEntry entry : iClientRepo.getAllEntries()) {
                EmiStack emiStack;
                if (entry.getStoredAmount() <= 0L || (emiStack = EmiStackHelper.toEmiStack(new GenericStack(entry.getWhat(), entry.getStoredAmount()))) == null) continue;
                list.add(emiStack);
            }
        }
        return new EmiPlayerInventory(list);
    }

    public boolean canCraft(EmiRecipe recipe, EmiCraftContext<T> context) {
        if (context.getType() == EmiCraftContext.Type.FILL_BUTTON) {
            return this.transferRecipe(recipe, context, false).canCraft();
        }
        return super.canCraft(recipe, context);
    }

    protected abstract Result transferRecipe(T var1, @Nullable class_1860<?> var2, EmiRecipe var3, boolean var4);

    protected final Result transferRecipe(EmiRecipe emiRecipe, EmiCraftContext<T> context, boolean doTransfer) {
        class_1860<?> holder;
        if (!this.containerClass.isInstance(context.getScreenHandler())) {
            return Result.createNotApplicable();
        }
        AEBaseMenu menu = (AEBaseMenu)((Object)this.containerClass.cast(context.getScreenHandler()));
        Result result = this.transferRecipe(menu, holder = this.getRecipeHolder(((AEBaseMenu)context.getScreenHandler()).getPlayer().method_37908(), emiRecipe), emiRecipe, doTransfer);
        if (result instanceof Result.Success && doTransfer) {
            class_310.method_1551().method_1507((class_437)context.getScreen());
        }
        return result;
    }

    public boolean supportsRecipe(EmiRecipe recipe) {
        return true;
    }

    public boolean craft(EmiRecipe recipe, EmiCraftContext<T> context) {
        return this.transferRecipe(recipe, context, true).canCraft();
    }

    public List<class_5684> getTooltip(EmiRecipe recipe, EmiCraftContext<T> context) {
        List<class_2561> tooltip = this.transferRecipe(recipe, context, false).getTooltip(recipe, context);
        if (tooltip != null) {
            return tooltip.stream().map(class_2561::method_30937).map(class_5684::method_32662).toList();
        }
        return super.getTooltip(recipe, context);
    }

    public void render(EmiRecipe recipe, EmiCraftContext<T> context, List<Widget> widgets, class_332 draw) {
        this.transferRecipe(recipe, context, false).render(recipe, context, widgets, draw);
    }

    @Nullable
    private class_1860<?> getRecipeHolder(class_1937 level, EmiRecipe recipe) {
        if (recipe.getBackingRecipe() != null) {
            return recipe.getBackingRecipe();
        }
        if (recipe.getId() != null) {
            return level.method_8433().method_8130(recipe.getId()).orElse(null);
        }
        return null;
    }

    protected final boolean isCraftingRecipe(class_1860<?> recipe, EmiRecipe emiRecipe) {
        return EncodingHelper.isSupportedCraftingRecipe(recipe) || emiRecipe.getCategory().equals(VanillaEmiRecipeCategories.CRAFTING);
    }

    protected final boolean fitsIn3x3Grid(class_1860<?> recipe, EmiRecipe emiRecipe) {
        if (recipe != null) {
            return recipe.method_8113(3, 3);
        }
        return true;
    }

    private static void renderMissingAndCraftableSlotOverlays(Map<Integer, SlotWidget> inputSlots, class_332 guiGraphics, Set<Integer> missingSlots, Set<Integer> craftableSlots) {
        for (Map.Entry<Integer, SlotWidget> entry : inputSlots.entrySet()) {
            boolean missing = missingSlots.contains(entry.getKey());
            boolean craftable = craftableSlots.contains(entry.getKey());
            if (!missing && !craftable) continue;
            class_4587 poseStack = guiGraphics.method_51448();
            poseStack.method_22903();
            poseStack.method_46416(0.0f, 0.0f, 400.0f);
            Bounds innerBounds = AbstractRecipeHandler.getInnerBounds(entry.getValue());
            guiGraphics.method_25294(innerBounds.x(), innerBounds.y(), innerBounds.right(), innerBounds.bottom(), missing ? 0x66FF0000 : 0x400000FF);
            poseStack.method_22909();
        }
    }

    private static boolean isInputSlot(SlotWidget slot) {
        return slot.getRecipe() == null;
    }

    private static Bounds getInnerBounds(SlotWidget slot) {
        Bounds bounds = slot.getBounds();
        return new Bounds(bounds.x() + 1, bounds.y() + 1, bounds.width() - 2, bounds.height() - 2);
    }

    private static Map<Integer, SlotWidget> getRecipeInputSlots(EmiRecipe recipe, List<Widget> widgets) {
        HashMap<Integer, SlotWidget> inputSlots = new HashMap<Integer, SlotWidget>(recipe.getInputs().size());
        for (int i = 0; i < recipe.getInputs().size(); ++i) {
            for (Widget widget : widgets) {
                SlotWidget slot;
                if (!(widget instanceof SlotWidget) || !AbstractRecipeHandler.isInputSlot(slot = (SlotWidget)widget) || slot.getStack() != recipe.getInputs().get(i)) continue;
                inputSlots.put(i, slot);
            }
        }
        return inputSlots;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    protected static abstract class Result {
        protected Result() {
        }

        @Nullable
        List<class_2561> getTooltip(EmiRecipe recipe, EmiCraftContext<?> context) {
            return null;
        }

        abstract boolean canCraft();

        void render(EmiRecipe recipe, EmiCraftContext<? extends AEBaseMenu> context, List<Widget> widgets, class_332 draw) {
        }

        static NotApplicable createNotApplicable() {
            return new NotApplicable();
        }

        static Success createSuccessful() {
            return new Success();
        }

        static Error createFailed(class_2561 text) {
            return new Error(text, Set.of());
        }

        static Error createFailed(class_2561 text, Set<Integer> missingSlots) {
            return new Error(text, missingSlots);
        }

        static final class NotApplicable
        extends Result {
            NotApplicable() {
            }

            @Override
            boolean canCraft() {
                return false;
            }
        }

        static final class Success
        extends Result {
            Success() {
            }

            @Override
            boolean canCraft() {
                return true;
            }
        }

        static final class Error
        extends Result {
            private final class_2561 message;
            private final Set<Integer> missingSlots;

            public Error(class_2561 message, Set<Integer> missingSlots) {
                this.message = message;
                this.missingSlots = missingSlots;
            }

            public class_2561 getMessage() {
                return this.message;
            }

            @Override
            boolean canCraft() {
                return false;
            }

            @Override
            void render(EmiRecipe recipe, EmiCraftContext<? extends AEBaseMenu> context, List<Widget> widgets, class_332 guiGraphics) {
                AbstractRecipeHandler.renderMissingAndCraftableSlotOverlays(AbstractRecipeHandler.getRecipeInputSlots(recipe, widgets), guiGraphics, this.missingSlots, Set.of());
            }
        }

        static final class EncodeWithCraftables
        extends Result {
            private final Set<AEKey> craftableKeys;

            public EncodeWithCraftables(Set<AEKey> craftableKeys) {
                this.craftableKeys = craftableKeys;
            }

            @Override
            boolean canCraft() {
                return true;
            }

            @Override
            List<class_2561> getTooltip(EmiRecipe emiRecipe, EmiCraftContext<?> context) {
                boolean anyCraftable = emiRecipe.getInputs().stream().anyMatch(ing -> EncodeWithCraftables.isCraftable(this.craftableKeys, ing));
                if (anyCraftable) {
                    return TransferHelper.createEncodingTooltip(true);
                }
                return null;
            }

            @Override
            void render(EmiRecipe recipe, EmiCraftContext<? extends AEBaseMenu> context, List<Widget> widgets, class_332 guiGraphics) {
                for (Widget widget : widgets) {
                    SlotWidget slot;
                    if (!(widget instanceof SlotWidget) || !AbstractRecipeHandler.isInputSlot(slot = (SlotWidget)widget) || !EncodeWithCraftables.isCraftable(this.craftableKeys, slot.getStack())) continue;
                    class_4587 poseStack = guiGraphics.method_51448();
                    poseStack.method_22903();
                    poseStack.method_46416(0.0f, 0.0f, 400.0f);
                    Bounds bounds = AbstractRecipeHandler.getInnerBounds(slot);
                    guiGraphics.method_25294(bounds.x(), bounds.y(), bounds.right(), bounds.bottom(), 0x400000FF);
                    poseStack.method_22909();
                }
            }

            private static boolean isCraftable(Set<AEKey> craftableKeys, EmiIngredient ingredient) {
                return ingredient.getEmiStacks().stream().anyMatch(emiIngredient -> {
                    GenericStack stack = EmiStackHelper.toGenericStack(emiIngredient);
                    return stack != null && craftableKeys.contains(stack.what());
                });
            }
        }

        static final class PartiallyCraftable
        extends Result {
            private final CraftingTermMenu.MissingIngredientSlots missingSlots;

            public PartiallyCraftable(CraftingTermMenu.MissingIngredientSlots missingSlots) {
                this.missingSlots = missingSlots;
            }

            @Override
            boolean canCraft() {
                return true;
            }

            @Override
            List<class_2561> getTooltip(EmiRecipe recipe, EmiCraftContext<?> context) {
                return TransferHelper.createCraftingTooltip(this.missingSlots, false);
            }

            @Override
            void render(EmiRecipe recipe, EmiCraftContext<? extends AEBaseMenu> context, List<Widget> widgets, class_332 guiGraphics) {
                AbstractRecipeHandler.renderMissingAndCraftableSlotOverlays(AbstractRecipeHandler.getRecipeInputSlots(recipe, widgets), guiGraphics, this.missingSlots.missingSlots(), this.missingSlots.craftableSlots());
            }
        }
    }
}

